<?php

include_once 'config.php';

 static $fileFullPath =null;

//Cria o arquivo de log se não existir e escreve a mensagem inicial
function createLogFile() {
    global $fileFullPath;
    $timestamp = date('Y-m-d H:i:s');
    $filename=$timestamp.'_log.txt';
    $fileFullPath= dirname(__DIR__). LOG_PATH . '/' . $filename;
    // Verifica se o arquivo já existe
    if (!file_exists($fileFullPath)) {
        // Cria o arquivo e escreve a mensagem inicial
        file_put_contents($fileFullPath, "$timestamp Log de Envio de SMSs\n");
    }
    
}

//Escreve no log
function writeLog( $message) {
    global $fileFullPath;
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message\n";
    
    // Abre o arquivo em modo de adição
    $file = fopen($fileFullPath, 'a');
    
    // Escreve a mensagem no arquivo
    fwrite($file, $logMessage);
    
    // Fecha o arquivo
    fclose($file);
}

?>