<?php


function sendShortLinkRequest($endpoint) {
   
    // verifica se está tudo definido Api_URL
    if (!defined('SHORTLINK_API_URL')) {
        throw new Exception('A constante SHORTLINK_API_URL deve ser definida.');
    }

    // Verifica se endpoint está definido
    if (empty($endpoint)) {
        throw new Exception('O endpoint deve ser definido.');
    }


    $url=SHORTLINK_API_URL .  $endpoint;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    //$jsonData=json_encode($data);
    //preciso de dar encode a  $data para x-www-form-urlencoded

    //echo $data;
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        throw new Exception("Erro de conexão: $curlError");
    }

    if ($httpCode >= 400) {
        throw new Exception("Erro HTTP $httpCode: " . json_encode($response));
    }
  
    return json_decode($response, true);
}



?>