<?php
function sendAuthRequest($endpoint, $data = []) {

    $headers = ['Content-Type: application/json'];

    // verifica se está tudo definido Api_URL
    if (!defined('API_URL')) {
        throw new Exception('A constante API_URL deve ser definida.');
    }

    // Verifica se endpoint está definido
    if (empty($endpoint)) {
        throw new Exception('O endpoint deve ser definido.');
    }

    $url=API_URL . $endpoint. "/?".urldecode(http_build_query($data ));

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);
    

    if ($curlError) {
        throw new Exception("Erro de Autenticação Moloni: $curlError");
    }

    if ($httpCode >= 400) {
        throw new Exception("Erro Autenticação Moloni HTTP $httpCode: " . json_encode($response));
    }
    
    return json_decode($response, true);
}


function sendRequest($endpoint, $data = [], $useAuth = true) {

    static $token = null;
    if ($useAuth && !$token) {
        try {
            $token = authenticate();
        } catch (Exception $e) {
            writeLog( $e->getMessage());
            die();
        }
    }
    

    $headers = ['Content-Type: application/x-www-form-urlencoded'];


    $url=API_URL . $endpoint. "/?access_token=".urlencode($token)."&json=true";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);

    $jsonData=json_encode($data);

    curl_setopt($ch, CURLOPT_POSTFIELDS,$jsonData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        throw new Exception("Erro de conexão: $curlError");
    }

    if ($httpCode >= 400) {
        throw new Exception("Erro HTTP $httpCode: " . json_encode($response));
    }
    
    return $response;
}



?>