<?php

include_once 'infrastructure/moloniApiClient.php';

class Customer
{

    private int $customer_id;
    private string $phone;
    private string $customer_phone;
    private int $price_class_id;

    //constructor with optional parameters

    public function __construct(int $customer_id = 0, string $phone = "", string $customer_phone = "", int $price_class_id = 0)
    {
        $this->customer_id = $customer_id;
        $this->phone = $phone;
        $this->customer_phone = $customer_phone;
        $this->price_class_id = $price_class_id;

        
    }


    public static function getClientById($customerId): Customer
    {
        $endpoint = 'customers/getOne/';
        $data = [
            'company_id' => COMPANY_ID,
            'customer_id' => $customerId,
        ];

        try {
            $client= sendRequest($endpoint, $data);
        } catch (Exception $e) {
            throw new Exception("Erro ao obter o cliente: " . $e->getMessage());
        }

        try {
            $client = self::jsonToCustomer($client);
        } catch (Exception $e) {
            throw new Exception("Erro ao converter JSON para cliente: " . $e->getMessage());
        }

        return $client;
    }

    // Verifica se o cliente tem a flag ativa
    public function hasFlag(): bool
    {   
        // Verifica se o cliente tem a flag definida 

        if (empty($this->price_class_id)) {
            throw new Exception("O cliente ". $this->customer_id ." não tem a flag definida");
            return false;
        }

        return $this->price_class_id == FLAG_SMS_PRICE_CLASS_ID;
    }

    // Verifica se um um dos numeros de telefone começa por 9 se sim retorna o número de telefone caso nenhum comece retorna 0
    public function checkPhone(): string
    {
        $finalPhone = 0;
        try {
           
       
                if (!empty($this->phone)) {

                    if (substr($this->phone, 0, 1) == '9') {
                        $finalPhone = $this->phone;
                    }
                
                }else if(!empty($this->customer_phone)) {
                    if (substr($this->customer_phone, 0, 1) == '9') {
                        $finalPhone = $this->customer_phone;
                    }
                }

            } catch (Exception $e) {
                throw new Exception("Erro ao verificar o telefone , customer " . $this->customer_id . ": " . $e->getMessage());
            }
        return $finalPhone;
    }
    
    //conver Json to Customer
    public static function jsonToCustomer($json): Customer
    {
        
        $json= json_decode($json, true);
 

        $customer = new Customer();
        $customer->setCustomerId($json['customer_id']);
        $customer->setPhone($json['phone']);
        $customer->setCustomerPhone($json['contact_phone']);
        $customer->setPriceClassId($json['price_class_id']);
      
        return $customer;
    }

    //getters

    public function getCustomerId(): int
    {
        return $this->customer_id;
    }
    public function getPhone(): string
    {
        return $this->phone;
    }
    public function getCustomerPhone(): string
    {
        return $this->customer_phone;
    }
    public function getPriceClassId(): int
    {
        return $this->price_class_id;
    }
    //setters

    public function setCustomerId(int $customer_id): void
    {
        $this->customer_id = $customer_id;
    }
    public function setPhone(string $phone): void
    {
        $this->phone = $phone;
    }
    public function setCustomerPhone(string $customer_phone): void
    {
        $this->customer_phone = $customer_phone;
    }
    public function setPriceClassId(int $price_class_id): void
    {
        $this->price_class_id = $price_class_id;
    }
    public function __toString(): string
    {
        return "Customer ID: {$this->customer_id}, Phone: {$this->phone}, Customer Phone: {$this->customer_phone}, Price Class ID: {$this->price_class_id}";
    }

}


