<?php
// Autenticação e obtenção do token
include_once 'config.php';
include_once 'infrastructure/moloniApiClient.php';



function authenticate() {

    // Verifica se as constantes estão definidas
    if (!defined('CLIENT_ID') || !defined('CLIENT_SECRET') || !defined('USERNAME') || !defined('PASSWORD')) {
        throw new Exception('As constantes CLIENT_ID, CLIENT_SECRET, USERNAME e PASSWORD devem ser definidas.');
    }

    $data = [
        'grant_type' => 'password',
        'client_id' => CLIENT_ID,
        'client_secret' => CLIENT_SECRET,
        'username' => USERNAME,
        'password' => PASSWORD,
    ];
    
    $response = sendAuthRequest('grant', $data, false);
    return $response['access_token'] ?? null;
}
?>